/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4j.serial;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.objects.collections.List;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import jssc.SerialPort;
import jssc.SerialPortException;
import jssc.SerialPortList;

@BA.Version(value=1.31f)
@BA.ShortName(value="Serial")
public class Serial {
    public static final int PURGE_RXABORT = 2;
    public static final int PURGE_RXCLEAR = 8;
    public static final int PURGE_TXABORT = 1;
    public static final int PURGE_TXCLEAR = 4;
    public static final int BAUDRATE_110 = 110;
    public static final int BAUDRATE_300 = 300;
    public static final int BAUDRATE_600 = 600;
    public static final int BAUDRATE_1200 = 1200;
    public static final int BAUDRATE_2400 = 2400;
    public static final int BAUDRATE_4800 = 4800;
    public static final int BAUDRATE_9600 = 9600;
    public static final int BAUDRATE_14400 = 14400;
    public static final int BAUDRATE_19200 = 19200;
    public static final int BAUDRATE_38400 = 38400;
    public static final int BAUDRATE_57600 = 57600;
    public static final int BAUDRATE_115200 = 115200;
    public static final int BAUDRATE_128000 = 128000;
    public static final int BAUDRATE_256000 = 256000;
    public static final int DATABITS_5 = 5;
    public static final int DATABITS_6 = 6;
    public static final int DATABITS_7 = 7;
    public static final int DATABITS_8 = 8;
    public static final int STOPBITS_1 = 1;
    public static final int STOPBITS_2 = 2;
    public static final int STOPBITS_1_5 = 3;
    public static final int PARITY_NONE = 0;
    public static final int PARITY_ODD = 1;
    public static final int PARITY_EVEN = 2;
    public static final int PARITY_MARK = 3;
    public static final int PARITY_SPACE = 4;
    public volatile int ReadingThreadInterval = 10;
    @BA.Hide
    public SerialPort sp;
    private String eventName;

    public void Initialize(String EventName) {
        this.eventName = EventName.toLowerCase(BA.cul);
    }

    public List ListPorts() {
        List l1 = new List();
        l1.Initialize();
        ((java.util.List)l1.getObject()).addAll(Arrays.asList(SerialPortList.getPortNames()));
        return l1;
    }

    public boolean SendBreak(int Duration2) throws SerialPortException {
        return this.sp.sendBreak(Duration2);
    }

    public boolean getDSR() throws SerialPortException {
        return this.sp.isDSR();
    }

    public void setDTR(boolean b) throws SerialPortException {
        this.sp.setDTR(b);
    }

    public boolean getCTS() throws SerialPortException {
        return this.sp.isCTS();
    }

    public void setRTS(boolean b) throws SerialPortException {
        this.sp.setRTS(b);
    }

    public void Open(String PortName) throws SerialPortException {
        this.sp = new SerialPort(PortName);
        this.sp.openPort();
    }

    public void PurgePort(int PurgeFlags) throws SerialPortException {
        this.sp.purgePort(PurgeFlags);
    }

    public void SetParams(int BaudRate, int DataBits, int StopBits, int Parity) throws SerialPortException {
        this.sp.setParams(BaudRate, DataBits, StopBits, Parity);
    }

    public boolean Close() throws SerialPortException {
        if (this.sp != null && this.sp.isOpened()) {
            return this.sp.closePort();
        }
        return true;
    }

    public InputStream GetInputStream() {
        return new InputStream(){

            @Override
            public int read() throws IOException {
                throw new RuntimeException("This method is not supported.");
            }

            @Override
            public int read(byte[] b) throws IOException {
                return this.read(b, 0, b.length);
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                try {
                    while (Serial.this.sp.getInputBufferBytesCount() == 0) {
                        Thread.sleep(Serial.this.ReadingThreadInterval);
                    }
                    byte[] read = Serial.this.sp.readBytes(Math.min(Serial.this.sp.getInputBufferBytesCount(), len));
                    System.arraycopy(read, 0, b, off, read.length);
                    return read.length;
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException(ie);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void close() throws IOException {
                try {
                    Serial.this.Close();
                }
                catch (SerialPortException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public OutputStream GetOutputStream() {
        return new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                throw new RuntimeException("This method is not supported.");
            }

            @Override
            public void write(byte[] b) throws IOException {
                this.write(b, 0, b.length);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                try {
                    if (off == 0 && len == b.length) {
                        byte[] dataToWrite = b;
                    } else {
                        byte[] dataToWrite = new byte[len];
                        System.arraycopy(b, off, dataToWrite, 0, len);
                    }
                    if (!Serial.this.sp.writeBytes(b)) {
                        throw new RuntimeException("Failed to write data. Data length = " + b.length);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void close() throws IOException {
                try {
                    Serial.this.Close();
                }
                catch (SerialPortException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }
}

