/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4j.objects;

import anywheresoftware.b4a.AbsObjectWrapper;
import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.keywords.Common;
import anywheresoftware.b4j.objects.ImageViewWrapper;
import anywheresoftware.b4j.objects.NodeWrapper;
import java.util.HashMap;
import java.util.List;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.util.Callback;

@BA.ShortName(value="TreeTableView")
public class TreeTableViewWrapper
extends NodeWrapper.ControlWrapper<TreeTableView<TreeTableColType[]>> {
    @Override
    @BA.Hide
    public void innerInitialize(final BA ba, final String eventName, boolean keepOldObject) {
        if (!keepOldObject) {
            this.setObject(new TreeTableView());
        }
        super.innerInitialize(ba, eventName, true);
        final TreeTableView ttv = (TreeTableView)this.getObject();
        if (ba.subExists(String.valueOf(eventName) + "_selecteditemchanged")) {
            ((TreeTableView)this.getObject()).getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<TreeItem<TreeTableColType[]>>(){

                public void changed(ObservableValue<? extends TreeItem<TreeTableColType[]>> arg0, TreeItem<TreeTableColType[]> arg1, TreeItem<TreeTableColType[]> arg2) {
                    ba.raiseEventFromUI(ttv, String.valueOf(eventName) + "_selecteditemchanged", AbsObjectWrapper.ConvertToWrapper(new TreeTableItemWrapper(), arg2));
                }
            });
        }
    }

    public void setRowHeight(double d) {
        ((TreeTableView)this.getObject()).setFixedCellSize(d);
    }

    public double getRowHeight() {
        return ((TreeTableView)this.getObject()).getFixedCellSize();
    }

    public void SetColumnSortable(int Index, boolean Sortable) {
        ((TreeTableColumn)((TreeTableView)this.getObject()).getColumns().get(Index)).setSortable(Sortable);
    }

    public int getColumnsCount() {
        return ((TreeTableView)this.getObject()).getColumns().size();
    }

    public String GetColumnHeader(int Index) {
        return ((TreeTableColumn)((TreeTableView)this.getObject()).getColumns().get(Index)).getText();
    }

    public void SetColumnHeader(int Index, String Header) {
        ((TreeTableColumn)((TreeTableView)this.getObject()).getColumns().get(Index)).setText(Header);
    }

    public double GetColumnWidth(int Index) {
        return ((TreeTableColumn)((TreeTableView)this.getObject()).getColumns().get(Index)).getWidth();
    }

    public void SetColumnWidth(int Index, double Width) {
        ((TreeTableColumn)((TreeTableView)this.getObject()).getColumns().get(Index)).setPrefWidth(Width);
    }

    public void SetColumnVisible(int Index, boolean Visible) {
        ((TreeTableColumn)((TreeTableView)this.getObject()).getColumns().get(Index)).setVisible(Visible);
    }

    public boolean GetColumnVisible(int Index) {
        return ((TreeTableColumn)((TreeTableView)this.getObject()).getColumns().get(Index)).isVisible();
    }

    public TreeTableItemWrapper getSelectedItem() {
        return (TreeTableItemWrapper)AbsObjectWrapper.ConvertToWrapper(new TreeTableItemWrapper(), ((TreeTableView)this.getObject()).getSelectionModel().getSelectedItem());
    }

    public void setSelectedItem(TreeTableItemWrapper ttt) {
        ((TreeTableView)this.getObject()).getSelectionModel().select((Object)((TreeItem)ttt.getObject()));
    }

    public void ClearSelection() {
        ((TreeTableView)this.getObject()).getSelectionModel().clearSelection();
    }

    public void SetColumns(anywheresoftware.b4a.objects.collections.List Columns) {
        ((TreeTableView)this.getObject()).getColumns().clear();
        if (Columns == null || !Columns.IsInitialized()) {
            return;
        }
        int colIndex = 0;
        double w = (this.getPrefWidth() - (double)Common.DipToCurrent(20)) / (double)Columns.getSize();
        for (Object colName : (List)Columns.getObject()) {
            TreeTableColumn tc = new TreeTableColumn(String.valueOf(colName));
            tc.setPrefWidth(w);
            tc.setCellValueFactory((Callback)new MyCellValueFactory(colIndex));
            tc.setSortable(false);
            ((TreeTableView)this.getObject()).getColumns().add((Object)tc);
            ++colIndex;
        }
        ((TreeTableView)this.getObject()).setRoot(new TreeItem(null));
        AbsObjectWrapper.getExtraTags(((TreeTableView)this.getObject()).getRoot()).put("tree", this.getObject());
        ((TreeTableView)this.getObject()).setShowRoot(false);
    }

    public TreeTableItemWrapper getRoot() {
        return (TreeTableItemWrapper)AbsObjectWrapper.ConvertToWrapper(new TreeTableItemWrapper(), ((TreeTableView)this.getObject()).getRoot());
    }

    public static Node build(Object prev, HashMap<String, Object> props, boolean designer, Object tag) throws Exception {
        TreeTableView vg = (TreeTableView)prev;
        if (vg == null) {
            vg = NodeWrapper.buildNativeView(TreeTableView.class, props, designer);
        }
        NodeWrapper.ControlWrapper.build((Object)vg, props, designer);
        String rawColumns = (String)props.get("columns");
        TreeTableViewWrapper tvw = new TreeTableViewWrapper();
        tvw.setObject(vg);
        anywheresoftware.b4a.objects.collections.List l1 = new anywheresoftware.b4a.objects.collections.List();
        l1.Initialize();
        String[] stringArray = rawColumns.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if ((s = s.trim()).length() > 0) {
                l1.Add(s);
            }
            ++n2;
        }
        if (designer) {
            boolean alreadySet = false;
            if (tvw.getColumnsCount() == l1.getSize()) {
                alreadySet = true;
                int i = 0;
                while (i < l1.getSize()) {
                    if (!tvw.GetColumnHeader(i).equals(l1.Get(i))) {
                        alreadySet = false;
                    }
                    ++i;
                }
                tvw.SetColumnHeader(0, "set");
            }
            if (!alreadySet) {
                tvw.SetColumns(l1);
                TreeTableItemWrapper ttw = tvw.getRoot();
                int i = 1;
                while (i < 6) {
                    TreeTableItemWrapper t = new TreeTableItemWrapper();
                    Object[] o = new Object[tvw.getColumnsCount()];
                    int c = 0;
                    while (c < o.length) {
                        o[c] = i;
                        ++c;
                    }
                    t.setObject(new TreeItem((Object)t.ArrayTo(o)));
                    if (i == 5) {
                        ttw = tvw.getRoot();
                    }
                    ttw.getChildren().Add(t.getObject());
                    t.setExpanded(true);
                    ttw = t;
                    ++i;
                }
            }
        } else {
            tvw.SetColumns(l1);
        }
        return vg;
    }

    private static class MyCellValueFactory
    implements Callback<TreeTableColumn.CellDataFeatures<TreeTableColType[], Object>, ObservableValue<Object>> {
        private final int colIndex;

        public MyCellValueFactory(int colIndex) {
            this.colIndex = colIndex;
        }

        public ObservableValue<Object> call(TreeTableColumn.CellDataFeatures<TreeTableColType[], Object> param) {
            return ((TreeTableColType[])param.getValue().getValue())[this.colIndex];
        }
    }

    @BA.Hide
    public static class TreeTableColType
    extends SimpleObjectProperty<Object> {
        public TreeTableColType(Object initialValue) {
            super(initialValue);
        }
    }

    @BA.ShortName(value="TreeTableItem")
    public static class TreeTableItemWrapper
    extends AbsObjectWrapper<TreeItem<TreeTableColType[]>> {
        public void Initialize(final BA ba, String EventName, Object[] Values2) {
            final String eventName = EventName.toLowerCase(BA.cul);
            this.setObject(new TreeItem((Object)this.ArrayTo(Values2)));
            final TreeItem me = (TreeItem)this.getObject();
            ((TreeItem)this.getObject()).expandedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
                    if (TreeTableItemWrapper.this.getChildren().getSize() == 0) {
                        TreeTableView<TreeTableColType[]> t = TreeTableItemWrapper.getTreeFromRoot((TreeItem<TreeTableColType[]>)me);
                        if (t != null && t.getSelectionModel().getSelectedItem() != me) {
                            t.getSelectionModel().select((Object)me);
                        }
                    } else {
                        ba.raiseEventFromUI(me, String.valueOf(eventName) + "_expandedchanged", (boolean)arg2);
                    }
                }
            });
        }

        @BA.Hide
        public static TreeTableView<TreeTableColType[]> getTreeFromRoot(TreeItem<TreeTableColType[]> me) {
            TreeItem parent = me;
            while (parent.getParent() != null) {
                parent = parent.getParent();
            }
            return (TreeTableView)AbsObjectWrapper.extraTagsGetValueIfAvailable(parent, "tree");
        }

        @BA.Hide
        public TreeTableColType[] ArrayTo(Object[] list) {
            TreeTableColType[] t = new TreeTableColType[list.length];
            int i = 0;
            while (i < t.length) {
                t[i] = new TreeTableColType(list[i]);
                ++i;
            }
            return t;
        }

        public Object GetValue(int Column) {
            return ((TreeTableColType[])((TreeItem)this.getObject()).getValue())[Column].get();
        }

        public void SetValue(int Column, Object Value) {
            ((TreeTableColType[])((TreeItem)this.getObject()).getValue())[Column].set(Value);
        }

        public TreeTableItemWrapper getParent() {
            return (TreeTableItemWrapper)AbsObjectWrapper.ConvertToWrapper(new TreeTableItemWrapper(), ((TreeItem)this.getObject()).getParent());
        }

        public boolean getRoot() {
            return ((TreeItem)this.getObject()).getParent() == null;
        }

        public void setExpanded(boolean b) {
            ((TreeItem)this.getObject()).setExpanded(b);
        }

        public boolean getExpanded() {
            return ((TreeItem)this.getObject()).isExpanded();
        }

        public anywheresoftware.b4a.objects.collections.List getChildren() {
            anywheresoftware.b4a.objects.collections.List l1 = new anywheresoftware.b4a.objects.collections.List();
            l1.setObject(((TreeItem)this.getObject()).getChildren());
            return l1;
        }

        public void setImage(Image Image2) {
            ImageView iv = new ImageView(Image2);
            ((TreeItem)this.getObject()).setGraphic((Node)iv);
        }

        public ImageViewWrapper.ImageWrapper getImage() {
            ImageViewWrapper.ImageWrapper iv = new ImageViewWrapper.ImageWrapper();
            if (((TreeItem)this.getObject()).getGraphic() instanceof ImageView) {
                iv.setObject(((ImageView)((TreeItem)this.getObject()).getGraphic()).getImage());
            }
            return iv;
        }
    }
}

